CREATE TABLE [dbo].[cdottitul] ( [id_dottitul] [int] IDENTITY (1,1) NOT NULL,[kod] [char] (5) COLLATE Czech_CI_AS NOT NULL,[nazev] [char] (100) COLLATE Czech_CI_AS NOT NULL,[pouzit] [bit] NOT NULL ) ON [PRIMARY]

CREATE TABLE [dbo].[cgupravy] ( [id_uprava] [int] IDENTITY (1,1) NOT NULL,[uprava] [numeric](2,0) NOT NULL,[paragraf] [char] (4) COLLATE Czech_CI_AS NOT NULL,[glb_ro] [bit] NOT NULL,[glb_zo] [bit] NOT NULL,[glb_po] [bit] NOT NULL,[glb_msmt] [bit] NOT NULL,[glb_obec] [bit] NOT NULL,[glb_kraj] [bit] NOT NULL,[kod_norm] [char] (5) COLLATE Czech_CI_AS NOT NULL,[norm_typ] [char] (20) COLLATE Czech_CI_AS NOT NULL,[kc_proc] [numeric](4,1) NOT NULL,[kc_abs] [numeric](8,0) NOT NULL,[poznamka] [char] (30) COLLATE Czech_CI_AS NOT NULL ) ON [PRIMARY]

CREATE TABLE [dbo].[cnormativy] ( [id_okres] [int] IDENTITY (1,1) NOT NULL,[kod_norm] [char] (9) COLLATE Czech_CI_AS NOT NULL,[pp] [char] (100) COLLATE Czech_CI_AS NOT NULL,[po] [char] (100) COLLATE Czech_CI_AS NOT NULL,[np] [char] (100) COLLATE Czech_CI_AS NOT NULL,[no] [char] (100) COLLATE Czech_CI_AS NOT NULL,[oniv_v] [numeric](8,2) NOT NULL,[oniv_f] [numeric](8,2) NOT NULL,[poradi] [numeric](5,0) NOT NULL,[forma_v] [numeric](4,2) NOT NULL,[forma_l] [numeric](4,2) NOT NULL,[forma_k] [numeric](4,2) NOT NULL,[forma_s] [numeric](4,2) NOT NULL,[forma_e] [numeric](4,2) NOT NULL,[forma_y] [numeric](4,2) NOT NULL ) ON [PRIMARY]

CREATE TABLE [dbo].[cnormuziv] ( [id_normuziv] [int] IDENTITY (1,1) NOT NULL,[kod_norm] [char] (9) COLLATE Czech_CI_AS NOT NULL,[kod_norm_o] [char] (9) COLLATE Czech_CI_AS NOT NULL,[v_od] [numeric](5,0) NOT NULL,[v_do] [numeric](5,0) NOT NULL ) ON [PRIMARY]

CREATE TABLE [dbo].[cpriplatky] ( [id_pripl] [int] IDENTITY (1,1) NOT NULL,[kod_norm] [char] (9) COLLATE Czech_CI_AS NOT NULL,[drp] [char] (1) COLLATE Czech_CI_AS NOT NULL,[koef_s] [numeric](4,2) NOT NULL,[koef_t] [numeric](4,2) NOT NULL,[koef_i] [numeric](4,2) NOT NULL,[oniv_prov] [numeric](5,0) NOT NULL,[koef_np] [numeric](5,3) NOT NULL,[koef_no] [numeric](5,3) NOT NULL ) ON [PRIMARY]

CREATE TABLE [dbo].[crozpocet] ( [id_rozpocet] [int] IDENTITY (1,1) NOT NULL,[id_izo] [int] NOT NULL,[izo] [char] (9) COLLATE Czech_CI_AS NOT NULL,[red_izo] [char] (9) COLLATE Czech_CI_AS NOT NULL,[paragraf] [char] (4) COLLATE Czech_CI_AS NOT NULL,[forma] [char] (1) COLLATE Czech_CI_AS NOT NULL,[zrizovatel] [char] (1) COLLATE Czech_CI_AS NOT NULL,[uprava] [numeric](2,0) NOT NULL,[gener] [bit] NOT NULL,[kod_norm] [char] (9) COLLATE Czech_CI_AS NOT NULL,[kod_forma] [char] (1) COLLATE Czech_CI_AS NOT NULL,[kod_pripl] [char] (1) COLLATE Czech_CI_AS NOT NULL,[drp] [char] (1) COLLATE Czech_CI_AS NOT NULL,[v] [numeric](5,0) NOT NULL,[t] [numeric](3,0) NOT NULL,[phmax] [numeric](6,2) NOT NULL,[vp] [numeric](4,2) NOT NULL,[fix_kompp] [bit] NOT NULL,[fix_kompo] [bit] NOT NULL,[fix_onivv] [bit] NOT NULL,[fix_onivf] [bit] NOT NULL,[np] [smallmoney] NULL,[npp] [smallmoney] NULL,[spp] [smallmoney] NULL,[fix_spp] [bit] NOT NULL,[spp_] [smallmoney] NULL,[no] [smallmoney] NULL,[npo] [smallmoney] NULL,[spo] [smallmoney] NULL,[fix_spo] [bit] NOT NULL,[spo_] [smallmoney] NULL,[pp] [numeric](5,0) NOT NULL,[po] [numeric](5,0) NOT NULL,[k1] [numeric](5,0) NOT NULL,[k2] [numeric](5,0) NOT NULL,[k3] [numeric](5,0) NOT NULL,[k4] [numeric](5,0) NOT NULL,[k2p] [numeric](3,1) NOT NULL,[k4p] [numeric](3,1) NOT NULL,[alfap] [numeric](4,3) NOT NULL,[alfao] [numeric](4,3) NOT NULL,[betap] [numeric](4,3) NOT NULL,[betao] [numeric](4,3) NOT NULL,[platyp] [numeric](10,0) NOT NULL,[fix_platyp] [bit] NOT NULL,[platyp_] [numeric](10,0) NOT NULL,[platyo] [numeric](10,0) NOT NULL,[fix_platyo] [bit] NOT NULL,[platyo_] [numeric](10,0) NOT NULL,[nenarp] [numeric](10,0) NOT NULL,[nenaro] [numeric](10,0) NOT NULL,[oovp] [numeric](10,0) NOT NULL,[fix_oovp] [bit] NOT NULL,[oovp_] [numeric](10,0) NOT NULL,[oovo] [numeric](10,0) NOT NULL,[fix_oovo] [bit] NOT NULL,[oovo_] [numeric](10,0) NOT NULL,[odstupne] [numeric](10,0) NOT NULL,[odstupnep] [numeric] (10,0) not null,[odstupneo] [numeric] (10,0) not null, [civsluzba] [numeric](10,0) NOT NULL,[refundace] [numeric](10,0) NOT NULL,[opppjine] [numeric](10,0) NOT NULL,[zdrpoj] [numeric](10,0) NOT NULL,[socpoj] [numeric](10,0) NOT NULL,[fksp] [numeric](10,0) NOT NULL,[zakpoj] [numeric](10,0) NOT NULL,[refpoj] [numeric](10,0) NOT NULL,[kor_zdrpoj] [numeric](10,0) NOT NULL,[kor_socpoj] [numeric](10,0) NOT NULL,[kor_fksp] [numeric](10,0) NOT NULL,[kor_zakpoj] [numeric](10,0) NOT NULL,[korekce] [numeric](10,0) NOT NULL,[oniv_z] [numeric](9,2) NOT NULL,[oniv_f] [numeric](10,0) NOT NULL,[oniv_v] [numeric](10,0) NOT NULL,[oniv_x] [numeric](10,0) NOT NULL,[oniv_xv] [numeric](10,0) NOT NULL,[oniv_xf] [numeric](10,0) NOT NULL,[oniv_zakpo] [numeric](10,0) NOT NULL,[oniv] [numeric](10,0) NOT NULL,[niv] [numeric](11,0) NOT NULL,[pocetmes] [numeric](2,0) NOT NULL,[poznamka] [char] (30) COLLATE Czech_CI_AS NOT NULL,[skolurad] [bit] NOT NULL,[dottitul] [char] (5) COLLATE Czech_CI_AS NOT NULL,[oniv_nahne] [numeric](10,0) NOT NULL,[externi] [bit] NOT NULL default 0) ON [PRIMARY]

CREATE TABLE [dbo].[csits] ( [id_izo] [int] IDENTITY (1,1) NOT NULL,[id_redizo] [int] NULL,[izo] [char] (9) COLLATE Czech_CI_AS NOT NULL,[red_izo] [char] (9) COLLATE Czech_CI_AS NOT NULL,[izonew] [char] (9) COLLATE Czech_CI_AS NOT NULL,[por_c] [char] (2) COLLATE Czech_CI_AS NOT NULL,[ico] [char] (8) COLLATE Czech_CI_AS NOT NULL,[id_typ] [int] NOT NULL,[typ] [char] (3) COLLATE Czech_CI_AS NOT NULL,[red_typ] [char] (3) COLLATE Czech_CI_AS NOT NULL,[nosna] [bit] NOT NULL,[zar_naz] [char] (25) COLLATE Czech_CI_AS NOT NULL,[zkratka] [char] (25) COLLATE Czech_CI_AS NOT NULL,[ulice] [char] (25) COLLATE Czech_CI_AS NOT NULL,[cp] [char] (5) COLLATE Czech_CI_AS NOT NULL,[misto] [char] (25) COLLATE Czech_CI_AS NOT NULL,[psc] [char] (5) COLLATE Czech_CI_AS NOT NULL,[uzemi] [char] (4) COLLATE Czech_CI_AS NOT NULL,[kop] [char] (7) COLLATE Czech_CI_AS NOT NULL,[paragraf] [char] (4) COLLATE Czech_CI_AS NOT NULL,[zriz] [numeric](1,0) NOT NULL,[zrizovatel] [char] (1) COLLATE Czech_CI_AS NOT NULL,[pforma] [numeric](3,0) NOT NULL,[forma] [char] (1) COLLATE Czech_CI_AS NOT NULL,[polozka] [char] (4) COLLATE Czech_CI_AS NOT NULL,[ropo] [char] (2) COLLATE Czech_CI_AS NOT NULL,[stredisko] [int] NOT NULL,[nove_izo] [bit] NOT NULL,[in_sit] [char] (1) COLLATE Czech_CI_AS NOT NULL,[in_vykony] [char] (1) COLLATE Czech_CI_AS NOT NULL,[in_mzdy] [char] (1) COLLATE Czech_CI_AS NOT NULL,[polo_ro] [char] (1) COLLATE Czech_CI_AS NOT NULL,[q_skut] [bit] NOT NULL,[q_komp] [bit] NOT NULL,[q_norm] [bit] NOT NULL,[maska] [char] (6) COLLATE Czech_CI_AS NOT NULL,[pp] [char] (100) COLLATE Czech_CI_AS NOT NULL,[po] [char] (100) COLLATE Czech_CI_AS NOT NULL,[civsluzba] [numeric](8,0) NOT NULL,[odstupne] [numeric](8,0) NOT NULL,[dohody_p] [numeric](8,0) NOT NULL,[dohody_o] [numeric](8,0) NOT NULL,[sp_p] [numeric](5,2) NOT NULL,[sp_o] [numeric](5,2) NOT NULL,[np] [varchar] (100) COLLATE Czech_CI_AS NOT NULL,[no] [varchar] (100) COLLATE Czech_CI_AS NOT NULL,[onivzak] [numeric](8,2) NOT NULL,[onivtri] [numeric](6,0) NOT NULL,[id_user] [int] NULL,[nazevplny] [varchar] (1000) COLLATE Czech_CI_AS NOT NULL,[castobce] [char] (35) COLLATE Czech_CI_AS NOT NULL default '',[agregovane] [bit] not null default 0,[agregtyp] [char] (10) not null default '') ON [PRIMARY]

CREATE TABLE [dbo].[cupravy] ( [id_uprava] [int] IDENTITY (1,1) NOT NULL,[g_cisupr] [numeric](2,0) NOT NULL,[g_datupr] [datetime] NOT NULL,[g_kodupr] [char] (1) COLLATE Czech_CI_AS NOT NULL,[g_poznamka] [char] (60) COLLATE Czech_CI_AS NOT NULL,[g_limniv] [numeric](11,0) NOT NULL,[g_limmp] [numeric](11,0) NOT NULL,[g_limplat] [numeric](11,0) NOT NULL,[g_limoppp] [numeric](11,0) NOT NULL,[g_limodv] [numeric](11,0) NOT NULL,[g_limonivf] [numeric](11,0) NOT NULL,[g_limonivv] [numeric](11,0) NOT NULL,[g_limoniv] [numeric](11,0) NOT NULL,[g_limspp] [numeric](9,4) NOT NULL,[g_limspo] [numeric](9,4) NOT NULL, [g_limplatp] [numeric] (11,0) NOT NULL,[g_limplato] [numeric] (11,0) NOT NULL,[g_limoovp] [numeric] (11,0) NOT NULL,[g_limoovo] [numeric] (11,0) NOT NULL, [gg_zaverka] [bit] NOT NULL ) ON [PRIMARY]

CREATE TABLE [dbo].[cvykony] ( [id_vykon] [int] IDENTITY (1,1) NOT NULL,[izo] [char] (9) COLLATE Czech_CI_AS NOT NULL,[kod_norm] [char] (9) COLLATE Czech_CI_AS NOT NULL,[v] [int] NOT NULL,[t] [int] NOT NULL,[kod_forma] [char] (1) COLLATE Czech_CI_AS NOT NULL,[drp] [char] (1) COLLATE Czech_CI_AS NOT NULL,[kod_pripl] [char] (1) COLLATE Czech_CI_AS NOT NULL ) ON [PRIMARY]

CREATE TABLE [dbo].[ckapacity] ([id_kapa] [int] identity (1,1) not null,[izo] [char](9) not null,[kod_oboru] [char](8) not null,[kod_forma] [char](1) not null,[kapacita] [int] not null)

CREATE TABLE [dbo].[smodi] ( [id_modi] [tinyint] IDENTITY (1,1) NOT NULL,[promenna] [char] (3) COLLATE Czech_CI_AS NOT NULL,[popis] [char] (25) COLLATE Czech_CI_AS NOT NULL,[hodnota] [bit] NOT NULL ) ON [PRIMARY]


CREATE TABLE [dbo].[sparm] ( [id_parm] [tinyint] IDENTITY (1,1) NOT NULL,[gc_nutskr] [char] (3) COLLATE Czech_CI_AS NOT NULL,[gc_nutsok] [char] (3) COLLATE Czech_CI_AS NOT NULL,[gc_nutsob] [char] (4) COLLATE Czech_CI_AS NOT NULL,[gl_obec] [bit] NOT NULL,[gl_samozpr] [bit] NOT NULL,[gl_rozdel] [bit] NOT NULL,[gl_ukazref] [bit] NOT NULL,[gc_kodsu] [char] (4) COLLATE Czech_CI_AS NOT NULL,[gc_ico] [char] (8) COLLATE Czech_CI_AS NOT NULL,[gn_zaokr] [numeric](4,0) NOT NULL,[gn_zus_1] [numeric](6,2) NOT NULL,[gn_zus_2] [numeric](6,2) NOT NULL,[gn_zus_7] [numeric](6,2) NOT NULL,[gn_zpoj_po] [numeric](4,2) NOT NULL,[gn_zpoj_zo] [numeric](4,2) NOT NULL,[gn_zpoj_ro] [numeric](4,2) NOT NULL,[gn_zpoj_su] [numeric](4,2) NOT NULL,[gn_kmes] [numeric](2,0) NOT NULL,[gn_spmes] [numeric](2,0) NOT NULL,[gc_prescas] [char] (3) COLLATE Czech_CI_AS NOT NULL,[gn_k2proc] [numeric](2,0) NOT NULL,[gn_k4proc] [numeric](2,0) NOT NULL,[gn_alfa] [numeric](5,4) NOT NULL,[gn_beta] [numeric](5,4) NOT NULL,[gn_gen_so] [numeric](2,0) NOT NULL,[gn_gen_co] [numeric](2,0) NOT NULL,[gn_navys_p] [numeric](4,3) NOT NULL,[gn_navys_n] [numeric](4,3) NOT NULL,[gl_archove] [bit] NOT NULL,[gl_archcop] [bit] NOT NULL,[gc_archpat] [char] (80) COLLATE Czech_CI_AS NOT NULL,[gl_zp_oniv] [bit] NOT NULL,[gl_autoupd] [bit] NOT NULL,[gl_dleobor] [bit] NOT NULL,[gl_agregace] [bit] NOT NULL, [gl_oborspc] [bit] NOT NULL default 0,[gl_impciz] [bit] NOT NULL default 0,[gn_nahnem] [numeric](6,4) NOT NULL default 0) ON [PRIMARY]

CREATE TABLE [dbo].[spath] ( [id_path] [tinyint] IDENTITY (1,1) NOT NULL,[sit_cesta] [char] (80) COLLATE Czech_CI_AS NOT NULL,[sit_maska] [char] (12) COLLATE Czech_CI_AS NOT NULL,[sit_kod] [char] (1) COLLATE Czech_CI_AS NOT NULL,[vyk_cesta] [char] (80) COLLATE Czech_CI_AS NOT NULL,[vyk_maska] [char] (12) COLLATE Czech_CI_AS NOT NULL,[vyk_kod] [char] (1) COLLATE Czech_CI_AS NOT NULL,[mzd_cesta] [char] (80) COLLATE Czech_CI_AS NOT NULL,[mzd_maska] [char] (12) COLLATE Czech_CI_AS NOT NULL,[mzd_kod] [char] (1) COLLATE Czech_CI_AS NOT NULL ) ON [PRIMARY]

CREATE TABLE [dbo].[sstav] ( [id_stav] [tinyint] IDENTITY (1,1) NOT NULL,[g_rezim] [bit] NOT NULL,[g_su] [bit] NOT NULL,[g_path] [bit] NOT NULL,[g_texty] [bit] NOT NULL,[gg_setup] [bit] NOT NULL,[g_sits] [tinyint] NOT NULL,[g_vykony] [tinyint] NOT NULL,[g_mzdy] [tinyint] NOT NULL,[gg_input] [bit] NOT NULL,[g_logsit] [tinyint] NOT NULL,[g_logvyk] [tinyint] NOT NULL,[g_logmzd] [tinyint] NOT NULL,[g_korekce] [tinyint] NOT NULL,[gg_log] [bit] NOT NULL,[g_okrkomp] [tinyint] NOT NULL,[g_okrnorm] [tinyint] NOT NULL,[g_okrskup] [tinyint] NOT NULL,[gg_okres] [bit] NOT NULL,[gg_global] [bit] NOT NULL,[gg_gener] [bit] NOT NULL,[gg_archiv] [bit] NOT NULL ) ON [PRIMARY]

CREATE TABLE [dbo].[stext] ( [id_text] [tinyint] IDENTITY (1,1) NOT NULL,[gc_nazevsu] [char] (50) COLLATE Czech_CI_AS NOT NULL,[gc_nazevs2] [char] (50) COLLATE Czech_CI_AS NOT NULL,[gc_adresa] [char] (35) COLLATE Czech_CI_AS NOT NULL,[gc_mesto] [char] (35) COLLATE Czech_CI_AS NOT NULL,[gc_psc] [char] (6) COLLATE Czech_CI_AS NOT NULL,[gc_reditel] [char] (35) COLLATE Czech_CI_AS NOT NULL,[gc_redtext] [char] (35) COLLATE Czech_CI_AS NOT NULL,[gc_vyriz] [char] (35) COLLATE Czech_CI_AS NOT NULL,[gc_datum] [char] (35) COLLATE Czech_CI_AS NOT NULL ) ON [PRIMARY]

CREATE TABLE [dbo].[susers] ( [id_user] [int] IDENTITY (1,1) NOT NULL,[username] [char] (25) COLLATE Czech_CI_AS NOT NULL,[fullname] [char] (50) COLLATE Czech_CI_AS NOT NULL,[telefon] [char] (25) COLLATE Czech_CI_AS NOT NULL,[email] [char] (50) COLLATE Czech_CI_AS NOT NULL,[password] [char] (32) COLLATE Czech_CI_AS NOT NULL,[userlevel] [char] (1) COLLATE Czech_CI_AS NOT NULL,[prava_zorg] [bit] NOT NULL,[prava_rorg] [bit] NOT NULL,[prava_porg] [bit] NOT NULL,[prava_corg] [bit] NOT NULL,[prava_sorg] [bit] NOT NULL,[prava_mp] [bit] NOT NULL,[prava_oniv] [bit] NOT NULL ) ON [PRIMARY]

ALTER TABLE [dbo].[susers] WITH NOCHECK ADD CONSTRAINT [IX_susers] UNIQUE CLUSTERED ( [id_user] ) ON [PRIMARY] 

CREATE CLUSTERED INDEX [PK_cpriplatky] ON [dbo].[cpriplatky]([id_pripl]) ON [PRIMARY]

CREATE CLUSTERED INDEX [PK_crozpocet] ON [dbo].[crozpocet]([id_rozpocet]) ON [PRIMARY]

CREATE INDEX [kod] ON [dbo].[cdottitul]([kod]) ON [PRIMARY]

CREATE INDEX [sort] ON [dbo].[cgupravy]([kod_norm]) ON [PRIMARY]

ALTER TABLE [dbo].[csits] ADD CONSTRAINT [DF_sits_id_typ] DEFAULT (0) FOR [id_typ],CONSTRAINT [DF__csits__nazevplny__1A14E395] DEFAULT ('') FOR [nazevplny] CREATE INDEX [redizotyp] ON [dbo].[csits]([red_izo],[typ]) ON [PRIMARY]

CREATE INDEX [typ] ON [dbo].[csits]([typ]) ON [PRIMARY]

CREATE INDEX [zkratka] ON [dbo].[csits]([zkratka]) ON [PRIMARY]

CREATE INDEX [nosne] ON [dbo].[csits]([zkratka]) ON [PRIMARY]

CREATE INDEX [nosna] ON [dbo].[csits]([zkratka]) ON [PRIMARY]

CREATE INDEX [nosna_pg] ON [dbo].[csits]([paragraf]) ON [PRIMARY]

CREATE INDEX [soucast_pg] ON [dbo].[csits]([paragraf]) ON [PRIMARY]

CREATE INDEX [soucast] ON [dbo].[csits]([zkratka]) ON [PRIMARY]

CREATE INDEX [skoly] ON [dbo].[csits]([red_izo],[typ]) ON [PRIMARY]

CREATE INDEX [izo] ON [dbo].[csits]([izo]) ON [PRIMARY]

CREATE INDEX [izo] ON [dbo].[cvykony]([izo]) ON [PRIMARY]

ALTER TABLE [dbo].[sparm] ADD CONSTRAINT [DF__sparm__gl_dleobo__164452B1] DEFAULT (0) FOR [gl_dleobor],CONSTRAINT [DF__sparm__gl_agrega__173876EA] DEFAULT (0) FOR [gl_agregace]

ALTER TABLE [dbo].[sstav] ADD CONSTRAINT [DF_sstav_g_sits] DEFAULT (0) FOR [g_sits],CONSTRAINT [DF_sstav_g_vykony] DEFAULT (0) FOR [g_vykony],CONSTRAINT [DF_sstav_g_mzdy] DEFAULT (0) FOR [g_mzdy],CONSTRAINT [DF_sstav_g_logsit] DEFAULT (0) FOR [g_logsit],CONSTRAINT [DF_sstav_g_logvyk] DEFAULT (0) FOR [g_logvyk],CONSTRAINT [DF_sstav_g_logmzd] DEFAULT (0) FOR [g_logmzd],CONSTRAINT [DF_sstav_g_korekce] DEFAULT (0) FOR [g_korekce],CONSTRAINT [DF_sstav_g_okrkomp] DEFAULT (0) FOR [g_okrkomp],CONSTRAINT [DF_sstav_g_okrnorm] DEFAULT (0) FOR [g_okrnorm],CONSTRAINT [DF_sstav_g_okrskup] DEFAULT (0) FOR [g_okrskup]


